## Create (Member)

Creates a calculated member/measure.




### Description

The following statement allows for adding calculated member to schema dimensions. It is very similar to the `WITH MEMBER` statement:

<pre>
CREATE [ CALCULATED ] MEMBER unique-name AS MDX-expression
</pre>

Note that for defining a `CALCULATED` measure you'll have to specify the cube the calculated measure declaration applies to (then the `[Measures]` dimension is optional):

<pre>
CREATE CALCULATED MEMBER [Sales].[Measures].[Diff with United States] AS '[Measures].[Amount] - ([Geography].[United States],[Measures].[Amount])'
</pre>

Please, check working examples for further explanation.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Market Share (calculated measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Note the usage of the cube name (i.e., [Sales]) in the CREATE statement.

**Query**

```
CREATE CALCULATED MEMBER [Sales].[Measures].[Market Share - schema] AS ([Measures].[Amount]) / ( [Product].currentMember.parent ,[Measures].[Amount] ), FORMAT_STRING = "Percent"
                
             
                
WITH
    MEMBER [Measures].[Market Share] AS [Measures].[Market Share - schema] -- using the schema definition

SELECT
    [Measures].[Market Share] ON 0,
    [Product].[icCube].children ON 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Market Share</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Corporate</td>
 <td>56.47%</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Partnership</td>
 <td>37.65%</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal</td>
 <td>5.88%</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Startup</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Market Share - select] AS ([Measures].[Amount]) / ( [Product].currentMember.parent ,[Measures].[Amount] ), FORMAT_STRING = "Percent"
    MEMBER [Measures].[Market Share] AS [Measures].[Market Share - select]  -- using the query definition

SELECT
    [Measures].[Market Share] ON 0,
    [Product].[icCube].children ON 1
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```


 
</div>

                                                                                                            

### See Also


[Calculated Members](Calculated%20Members.md)

[Drop (Member)](Drop%20(Member).md)

[Create (Function)](Create%20(Function).md)

[Create (Set)](Create%20(Set).md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
